#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>
#include <cmath>
using namespace std;

int max_velicina_vojske(int N, int P, vector<int>& M, vector<int>& A, vector<int>& L, vector<int>& R) {
    vector<int> sve_opcije;

    for (int i = 0; i < pow(2, N); ++i) {
        int trenutna_velicina = P;
        bool validna_opcija = true;

        for (int j = 0; j < N; ++j) {
            if (i & (1 << j)) {
                trenutna_velicina *= M[j];
            } else {
                trenutna_velicina += A[j];
            }

            if (trenutna_velicina < L[j] || trenutna_velicina > R[j]) {
                validna_opcija = false;
                break;
            }
        }

        if (validna_opcija) {
            sve_opcije.push_back(trenutna_velicina);
        }
    }

    if (sve_opcije.empty()) {
        return -1;
    }

    int maksimalna_velicina = *max_element(sve_opcije.begin(), sve_opcije.end());

    return maksimalna_velicina;
}

int main() {
    int T;
    cin >> T;

    for (int t = 0; t < T; ++t) {
        int N, P;
        cin >> N >> P;

        vector<int> M(N), A(N), L(N), R(N);

        for (int i = 0; i < N; ++i) {
            cin >> M[i];
        }

        for (int i = 0; i < N; ++i) {
            cin >> A[i];
        }

        for (int i = 0; i < N; ++i) {
            cin >> L[i];
        }

        for (int i = 0; i < N; ++i) {
            cin >> R[i];
        }

        int rezultat = max_velicina_vojske(N, P, M, A, L, R);

        if (rezultat == -1) {
            cout << "nemoguce" << endl;
        } else {
            cout << rezultat << endl;
        }
    }

    return 0;
}